package tests;

import centralSystem.CentralSystem;
import centralSystem.ICentralSystem;
import centralSystem.IPostCounter;
import centralSystem.counters.LongestQueueCounter;
import devices.TicketPrinter;
import devices.Visualizer;

public class CountersTest {
	
	static ICentralSystem sys = new CentralSystem(new TicketPrinter(), new Visualizer());
	static IPostCounter counter = new LongestQueueCounter(sys);
	
	private static void printQueueState() {
		for (int i = 0; i < 3; i++) {
			System.out.println(i+": "+sys.getNextClient(i)+"/"+sys.getTotalClient(i));
		}
		System.out.println("");
	}
	
	public static void main(String[] args) {
		
		printQueueState();
		sys.addClientAtQueue(0);
		sys.addClientAtQueue(0);
		sys.addClientAtQueue(2);
		sys.addClientAtQueue(2);
		printQueueState();
		counter.nextService();
		printQueueState();
		counter.nextService();
		printQueueState();
		sys.addClientAtQueue(0);
		sys.addClientAtQueue(0);
		sys.addClientAtQueue(0);
		counter.nextService();
		printQueueState();
		
	}
}
